﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using System.IO;

namespace PlikiTekstowe
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        public static string[] CzytajPlikTekstowy(string nazwaPliku)
        {
            List<string> tekst = new List<string>();
            try
            {
                using (StreamReader sr = new StreamReader(nazwaPliku))
                {
                    string wiersz;
                    while ((wiersz = sr.ReadLine()) != null)
                        tekst.Add(wiersz);
                }
                return tekst.ToArray();
            }
            catch (Exception e)
            {
                MessageBox.Show("Błąd odczytu pliku " + nazwaPliku + " (" + e.Message + ")");
                return null;
            }
        }

        private void fileListBox1_DwukrotneKliknieciePliku(object sender, EventArgs e, string nazwaPliku)
        {
            textBox1.Lines = CzytajPlikTekstowy(nazwaPliku);
        }

        private void fileListBox1_MouseDown(object sender, MouseEventArgs e)
        {
            string ścieżkaPliku = fileListBox1.ŚcieżkaDoZaznaczonegoElementu;
            if (e.Button == MouseButtons.Left && File.Exists(ścieżkaPliku))
            {
                DragDropEffects operacja = fileListBox1.DoDragDrop(ścieżkaPliku, DragDropEffects.Move);
            }
        }

        private void textBox1_DragOver(object sender, DragEventArgs e)
        {
            e.Effect = DragDropEffects.Move;
        }

        private void textBox1_DragDrop(object sender, DragEventArgs e)
        {
            textBox1.Lines = CzytajPlikTekstowy(e.Data.GetData(DataFormats.Text).ToString());
            //textBox1.Lines = CzytajPlikTekstowy(fileListBox1.ŚcieżkaDoZaznaczonegoElementu);
        }
    }
}
